/*----------------------------------------------------------------------------
 * Name:    timer.c
 * Purpose: 
 * Note(s): 
 *----------------------------------------------------------------------------
 * This file is part of the uVision/ARM development tools.
 * This software may only be used under the terms of a valid, current,
 * end user licence from KEIL for a compatible version of KEIL software
 * development tools. Nothing else gives you the right to use this software.
 *
 * This software is supplied "AS IS" without warranties of any kind.
 *
 * Copyright (c) 2012 Keil - An ARM Company. All rights reserved.
 *----------------------------------------------------------------------------*/
#include	"timer.h"
 
timer_operate_t timer_operate;
timer_operate_t UART_timer_operate;
/*****************************************************************************************************
* @brief  Configures BFTM0
* @retval None
*******************************************************************************************************/
void BFTM0_configure(void)
{
	HT_BFTM0->CR = ((1UL << 0) |     /* Compare Match Interrupt is disabled */
						 (0UL << 1) |		/* Counter operates in repetitive mode */
						 (0UL << 2) );    /* BFTM0 is disabled */
	HT_BFTM0->CMP = (SystemCoreClock / 1000000UL) * 1000UL;
   HT_BFTM0->SR = 0UL;					/* clear Compare Match Interrupt Flag */
	HT_BFTM0->CR |= BFTM_CEN;      	/* BFTM0 is enable */
	NVIC_EnableIRQ(BFTM0_IRQn);      /* Enable NVIC Basic Function Timer0 interrupt */	
}

/*****************************************************************************************************
* @brief  return tick value (ms)
* @retval None
*******************************************************************************************************/
u32	RESET_TICK_COUNT(void)
{
	timer_operate.value = 0;
	return	timer_operate.value;	
}
/*****************************************************************************************************
* @brief  return tick value (ms)
* @retval None
*******************************************************************************************************/
u32	GET_TICK_COUNT(void)
{
	return	timer_operate.value;	
}
/*****************************************************************************************************
* @brief  delay n*ms
* @retval None
*******************************************************************************************************/
void delay_ms(unsigned long n) 
{
	HT_BFTM1->CR = ((0UL << 0) |     /* Compare Match Interrupt is disabled */
						 (0UL << 1) |		/* Counter operates in repetitive mode */
						 (0UL << 2) );    /* BFTM is disabled */
	HT_BFTM1->CMP = (SystemCoreClock / 1000000UL) * 1000UL;
   HT_BFTM1->SR = 0UL;					/* clear Compare Match Interrupt Flag */	
	HT_BFTM1->CR |= BFTM_CEN;      	/* BFTM is enable */
	while(n) 
	{
		while( !(HT_BFTM1->SR & BFTM_MIF));
		n--;
		HT_BFTM1->SR = 0UL;				/* clear Compare Match Interrupt Flag */		
	}
	HT_BFTM1->CR &= ~BFTM_CEN;     	/* BFTM is disable */	
}
/*****************************************************************************************************
* @brief  delay n*10us
* @retval None
*******************************************************************************************************/
void delay_10us(unsigned long n) 
{
	HT_BFTM1->CR = ((0UL << 0) |     /* Compare Match Interrupt is disabled */
						 (0UL << 1) |		/* Counter operates in repetitive mode */
						 (0UL << 2) );    /* BFTM1 disable */
	HT_BFTM1->CMP = (SystemCoreClock / 1000000UL) * 10UL;
	HT_BFTM1->SR = 0UL;					/* clear Compare Match Interrupt Flag */			
	HT_BFTM1->CR |= BFTM_CEN;      	/* BFTM1 is enable */
	while(n) 
	{
		while( !(HT_BFTM1->SR & BFTM_MIF));
		n--;
		HT_BFTM1->SR = 0UL;				/* clear Compare Match Interrupt Flag */				
	}
	HT_BFTM1->CR &= ~BFTM_CEN;      	/* BFTM1 is disable */	
}
